<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

include 'DbConnect.php'; 
$objDb = new DbConnect();
$conn = $objDb->connect();

if ($conn == null) {
    $response['message'] = 'Veritabanı bağlantısı başarısız.';
    echo json_encode($response);
    exit();
}

$method = $_SERVER['REQUEST_METHOD'];
$response = ['status' => 0, 'message' => '', 'data' => []];

if ($method === "GET") {
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    if (!empty($id)) {
        $sql = "SELECT SQL_NO_CACHE id, title, titleEn, titleRu, video FROM videos WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $avia = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $response['data'] = $avia;
    } else {
        $sql = "SELECT SQL_NO_CACHE id, title, titleEn, titleRu, video FROM videos";
        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $avia = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $response['data'] = $avia;
    }
    $response['status'] = 1;
    $response['message'] = 'Videos fetched successfully';
    echo json_encode($response);
    exit();
}


if ($method === "POST") {
    $id = isset($_POST['id']) ? $_POST['id'] : null;
    $title = $_POST['title'];
    $titleEn = $_POST['titleEn'];
    $titleRu = $_POST['titleRu'];
    
    $videoPath = null;

    if (isset($_FILES['video']) && $_FILES['video']['error'] === 0) {
        $target_dir = "videos/";
        $video = basename($_FILES['video']['name']);
        $target_file = $target_dir . $video;
        $videoFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        
        $allowedTypes = ['mp4', 'avi', 'mov', 'mkv'];
        if (!in_array($videoFileType, $allowedTypes)) {
            echo json_encode(['status' => 0, 'message' => "Sadece MP4, AVI, MOV ve MKV dosyaları yüklenebilir."]);
            exit();
        }

        if (!move_uploaded_file($_FILES['video']['tmp_name'], $target_file)) {
            echo json_encode(['status' => 0, 'message' => "Video yüklenirken hata oluştu."]);
            exit();
        }
        $videoPath = $target_file;
    }

    if ($id) {
        if ($videoPath) {
            $sql = "UPDATE videos SET title = :title, titleEn = :titleEn, titleRu = :titleRu, video = :video WHERE id = :id";
        } else {
            $sql = "UPDATE videos SET title = :title, titleEn = :titleEn, titleRu = :titleRu WHERE id = :id";
        }
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->bindParam(':title', $title);
        $stmt->bindParam(':titleEn', $titleEn);
        $stmt->bindParam(':titleRu', $titleRu);
        
        if ($videoPath) {
            $stmt->bindParam(':video', $videoPath);
        }

        if ($stmt->execute()) {
            echo json_encode(['status' => 1, 'message' => 'Video updated successfully']);
        } else {
            echo json_encode(['status' => 0, 'message' => 'Error updating video']);
        }
    } else {
        $sql = "INSERT INTO videos (title, titleEn, titleRu, video) 
                VALUES (:title, :titleEn, :titleRu, :video)";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':title', $title);
        $stmt->bindParam(':titleEn', $titleEn);
        $stmt->bindParam(':titleRu', $titleRu);
        $stmt->bindParam(':video', $videoPath);

        if ($stmt->execute()) {
            echo json_encode(['status' => 1, 'message' => 'Video added successfully']);
        } else {
            echo json_encode(['status' => 0, 'message' => 'Video could not be added']);
        }
    }
    exit();
}


if ($method === "DELETE") {
    $id = isset($_GET['id']) ? $_GET['id'] : null;
    
    if ($id) {
        $sql = "DELETE FROM videos WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        
        $response['status'] = 1;
        $response['message'] = 'Video deleted successfully';
    } else {
        $response['status'] = 0;
        $response['message'] = 'Invalid video ID';
    }

    echo json_encode($response);
    exit();
}

$response['message'] = 'Method not allowed';
echo json_encode($response);
?>
