<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include 'DbConnect.php'; // Veritabanı bağlantı dosyası
$objDb = new DbConnect();
$conn = $objDb->connect();

// Veritabanı bağlantısını kontrol et
if ($conn == null) {
    $response['message'] = 'Veritabanı bağlantısı başarısız.';
    echo json_encode($response);
    exit();
}

$method = $_SERVER['REQUEST_METHOD'];
$path = explode('/', trim($_SERVER['REQUEST_URI'], '/')); // Doğru yazım

$response = ['status' => 0, 'message' => '', 'data' => []]; // data ekledik

if ($method === "GET") {
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    if (!empty($id)) {
        // id ile filtreleme
        $sql = "SELECT id, instagram, tiktok, whatsapp, location, mobile, email, map FROM settings WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $tours = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $response['data'] = $tours;
    } else {
        // Tüm veriler
        $sql = "SELECT id, instagram, tiktok, whatsapp, location, mobile, email, map FROM settings";
        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $tours = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $response['data'] = $tours;
    }
    $response['status'] = 1; // Başarı durumu
    $response['message'] = 'Tours fetched successfully'; // Mesaj
    echo json_encode($response); // Yanıtı JSON olarak döndürdük
    exit();
}


if ($method === "PUT") {
    $putData = json_decode(file_get_contents("php://input"), true); // JSON verisini alıyoruz

    $id = isset($putData['id']) ? $putData['id'] : null;
    $instagram = isset($putData['instagram']) ? $putData['instagram'] : '';
    $tiktok = isset($putData['tiktok']) ? $putData['tiktok'] : '';
    $whatsapp = isset($putData['whatsapp']) ? $putData['whatsapp'] : '';
    $location = isset($putData['location']) ? $putData['location'] : '';
    $mobile = isset($putData['mobile']) ? $putData['mobile'] : '';
    $email = isset($putData['email']) ? $putData['email'] : '';
    $map = isset($putData['map']) ? $putData['map'] : '';

    
    if (!empty($id)) {
        // Ürünü güncelleme SQL sorgusu
        $sql = "UPDATE settings SET instagram = :instagram, tiktok = :tiktok, whatsapp = :whatsapp, location = :location, mobile = :mobile, email = :email, map = :map WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->bindParam(':instagram', $instagram);
        $stmt->bindParam(':tiktok', $tiktok);
        $stmt->bindParam(':whatsapp', $whatsapp);
        $stmt->bindParam(':location', $location);
        $stmt->bindParam(':mobile', $mobile);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':map', $map);

        if ($stmt->execute()) {
            $response['status'] = 1;
            $response['message'] = 'Product updated successfully';
        } else {
            $response['status'] = 0;
            $response['message'] = 'Error updating product';
        }
    } else {
        $response['status'] = 0;
        $response['message'] = 'Product ID is required for update';
    }

    echo json_encode($response);
    exit();
}








// Desteklenmeyen HTTP metodları için hata mesajı
$response['message'] = 'Method not allowed';
echo json_encode($response);
?>