<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

include 'DbConnect.php'; // Veritabanı bağlantı dosyası
$objDb = new DbConnect();
$conn = $objDb->connect();

// Veritabanı bağlantısını kontrol et
if ($conn == null) {
    $response['message'] = 'Veritabanı bağlantısı başarısız.';
    echo json_encode($response);
    exit();
}

$method = $_SERVER['REQUEST_METHOD'];
$path = explode('/', trim($_SERVER['REQUEST_URI'], '/')); // Doğru yazım

$response = ['status' => 0, 'message' => '', 'data' => []]; // data ekledik

if ($method === "GET") {
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    if (!empty($id)) {
        // id ile filtreleme
        $sql = "SELECT SQL_NO_CACHE id, title, titleEn, titleRu, content, contentEn, contentRu, image FROM sectors WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $avia = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $response['data'] = $avia;
    } else {
        // Tüm veriler
        $sql = "SELECT SQL_NO_CACHE id, title, titleEn, titleRu, content, contentEn, contentRu, image FROM sectors";
        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $avia = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $response['data'] = $avia;
    }
    $response['status'] = 1; // Başarı durumu
    $response['message'] = 'Avia fetched successfully'; // Mesaj
    echo json_encode($response); // Yanıtı JSON olarak döndürdük
    exit();
}



if ($method === "POST") {


    $id = isset($_POST['id']) ? $_POST['id'] : null;
    $title = $_POST['title'];
    $titleEn = $_POST['titleEn'];
    $titleRu = $_POST['titleRu'];
    $content = $_POST['content'];
    $contentEn = $_POST['contentEn'];
    $contentRu = $_POST['contentRu'];
    
     $imagePath = null;

    // Eğer resim yüklenmişse işle
    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
        $target_dir = "sectors/";
        $image = basename($_FILES['image']['name']);
        $target_file = $target_dir . $image;
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        
        $allowedTypes = ['jpg', 'jpeg', 'png', 'gif'];
        if (!in_array($imageFileType, $allowedTypes)) {
            echo json_encode(['status' => 0, 'message' => "Sadece JPG, JPEG, PNG ve GIF dosyaları yüklenebilir."]);
            exit();
        }

        if (!move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
            echo json_encode(['status' => 0, 'message' => "Dosya yüklenirken hata oluştu."]);
            exit();
        }
        $imagePath = $target_file;
    }
    

    
    if ($id) {
        // Güncelleme işlemi
        if ($imagePath) {
            // Resim de değiştirilmiş ise resim yolunu da güncelle
            $sql = "UPDATE sectors SET title = :title, titleEn = :titleEn, titleRu = :titleRu, content = :content, contentEn = :contentEn, contentRu = :contentRu, image = :image WHERE id = :id";
        } else {
            // Resim değişmemişse resim alanını güncelleme
            $sql = "UPDATE sectors SET  title = :title, titleEn = :titleEn, titleRu = :titleRu, content = :content, contentEn = :contentEn, contentRu = :contentRu WHERE id = :id";
        }
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->bindParam(':title', $title);
        $stmt->bindParam(':titleEn', $titleEn);
        $stmt->bindParam(':titleRu', $titleRu);
        $stmt->bindParam(':content', $content);
        $stmt->bindParam(':contentEn', $contentEn);
        $stmt->bindParam(':contentRu', $contentRu);
        
        if ($imagePath) {
            $stmt->bindParam(':image', $imagePath);
        }

        if ($stmt->execute()) {
            echo json_encode(['status' => 1, 'message' => 'Product updated successfully']);
        } else {
            echo json_encode(['status' => 0, 'message' => 'Error updating product']);
        }
    } else {
        // Yeni kayıt ekleme
        $sql = "INSERT INTO sectors (title, titleEn, titleRu, content, contentEn, contentRu, image) 
            VALUES (:title, :titleEn, :titleRu, :content, :contentEn, :contentRu,  :image)";
        $stmt = $conn->prepare($sql);
    $stmt->bindParam(':title', $title);
    $stmt->bindParam(':titleEn', $titleEn);
    $stmt->bindParam(':titleRu', $titleRu);
    $stmt->bindParam(':content', $content);
    $stmt->bindParam(':contentEn', $contentEn);
    $stmt->bindParam(':contentRu', $contentRu);
        $stmt->bindParam(':image', $imagePath);

        if ($stmt->execute()) {
            echo json_encode(['status' => 1, 'message' => 'Product added successfully']);
        } else {
            echo json_encode(['status' => 0, 'message' => 'Product could not be added']);
        }
    }
    exit();
}



if ($method === "DELETE") {
    // Retrieve the ID directly from the URL query parameter
    $id = isset($_GET['id']) ? $_GET['id'] : null;
    error_log("Received ID from URL: " . $id);  // Log the ID received from the URL
    
    if ($id) {
        error_log("Valid ID received: " . $id);  // Log valid ID
        
        // Perform the delete operation
        $sql = "DELETE FROM sectors WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        
        $response['status'] = 1;
        $response['message'] = 'Product deleted successfully';
    } else {
        error_log("No valid ID found in request.");  // Log missing ID
        $response['status'] = 0;
        $response['message'] = 'Invalid product ID';
    }

    echo json_encode($response);
    exit();
}







// Desteklenmeyen HTTP metodları için hata mesajı
$response['message'] = 'Method not allowed';
echo json_encode($response);
?>
