<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once  'DbConnect.php';

try {
    $database = new DbConnect();
    $db = $database->connect();

    $query = "
        SELECT 
            pfo.id,
            pfo.product_id,
            pfo.filter_option_id,
            p.name as product_name,
            fo.value as filter_option_value,
            f.name as filter_name
        FROM product_filter_options pfo
        LEFT JOIN products p ON pfo.product_id = p.id
        LEFT JOIN filter_options fo ON pfo.filter_option_id = fo.id
        LEFT JOIN filters f ON fo.filter_id = f.id
        ORDER BY pfo.id DESC
    ";
    
    $stmt = $db->prepare($query);
    $stmt->execute();
    
    $items = array();
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $items[] = $row;
    }
    
    echo json_encode(["status" => 1, "message" => "Product filter options with details fetched successfully", "data" => $items]);

} catch (Exception $e) {
    echo json_encode(["status" => 0, "message" => "Database error: " . $e->getMessage()]);
}
?>