<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, DELETE");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once  'DbConnect.php';

$method = $_SERVER['REQUEST_METHOD'];

try {
    $database = new DbConnect();
    $db = $database->connect();

    // GET - Tüm ürün filtre seçeneklerini getir
    if ($method == 'GET') {
        if (isset($_GET['id'])) {
            $id = $_GET['id'];
            $query = "SELECT * FROM product_filter_options WHERE id = :id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':id', $id);
            $stmt->execute();
            
            if ($stmt->rowCount() > 0) {
                $item = $stmt->fetch(PDO::FETCH_ASSOC);
                echo json_encode(["status" => 1, "message" => "Product filter option fetched successfully", "data" => [$item]]);
            } else {
                echo json_encode(["status" => 0, "message" => "Product filter option not found", "data" => []]);
            }
        } else {
            $query = "SELECT * FROM product_filter_options";
            $stmt = $db->prepare($query);
            $stmt->execute();
            
            $items = array();
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $items[] = $row;
            }
            
            echo json_encode(["status" => 1, "message" => "Product filter options fetched successfully", "data" => $items]);
        }
    }
    
    // POST - Yeni ürün filtre seçeneği ekle
    elseif ($method == 'POST') {
        $data = json_decode(file_get_contents("php://input"));
        
        if (!isset($data->product_id) || !isset($data->filter_option_id)) {
            echo json_encode(["status" => 0, "message" => "Missing required fields: product_id and filter_option_id"]);
            exit;
        }
        
        // Aynı kaydın var olup olmadığını kontrol et
        $checkQuery = "SELECT id FROM product_filter_options WHERE product_id = :product_id AND filter_option_id = :filter_option_id";
        $checkStmt = $db->prepare($checkQuery);
        $checkStmt->bindParam(':product_id', $data->product_id);
        $checkStmt->bindParam(':filter_option_id', $data->filter_option_id);
        $checkStmt->execute();
        
        if ($checkStmt->rowCount() > 0) {
            echo json_encode(["status" => 0, "message" => "This filter option is already assigned to this product"]);
            exit;
        }
        
        $query = "INSERT INTO product_filter_options (product_id, filter_option_id) VALUES (:product_id, :filter_option_id)";
        $stmt = $db->prepare($query);
        
        $stmt->bindParam(':product_id', $data->product_id);
        $stmt->bindParam(':filter_option_id', $data->filter_option_id);
        
        if ($stmt->execute()) {
            echo json_encode(["status" => 1, "message" => "Product filter option created successfully"]);
        } else {
            echo json_encode(["status" => 0, "message" => "Product filter option creation failed"]);
        }
    }
    
    // DELETE - Ürün filtre seçeneği sil
    elseif ($method == 'DELETE') {
        $id = $_GET['id'];
        
        if (!isset($id)) {
            echo json_encode(["status" => 0, "message" => "Missing id parameter"]);
            exit;
        }
        
        $query = "DELETE FROM product_filter_options WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $id);
        
        if ($stmt->execute()) {
            echo json_encode(["status" => 1, "message" => "Product filter option deleted successfully"]);
        } else {
            echo json_encode(["status" => 0, "message" => "Product filter option deletion failed"]);
        }
    }

} catch (Exception $e) {
    echo json_encode(["status" => 0, "message" => "Database error: " . $e->getMessage()]);
}
?>