<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once  'DbConnect.php';

$method = $_SERVER['REQUEST_METHOD'];

try {
    $database = new DbConnect();
    $db = $database->connect();

    // GET - Tüm filtreleri veya belirli bir filtreyi getir
    if ($method == 'GET') {
        if (isset($_GET['id'])) {
            $id = $_GET['id'];
            $query = "SELECT * FROM filters WHERE id = :id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':id', $id);
            $stmt->execute();
            
            if ($stmt->rowCount() > 0) {
                $filter = $stmt->fetch(PDO::FETCH_ASSOC);
                echo json_encode(["status" => 1, "message" => "Filter fetched successfully", "data" => [$filter]]);
            } else {
                echo json_encode(["status" => 0, "message" => "Filter not found", "data" => []]);
            }
        } else {
            $query = "SELECT * FROM filters";
            $stmt = $db->prepare($query);
            $stmt->execute();
            
            $filters = array();
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $filters[] = $row;
            }
            
            echo json_encode(["status" => 1, "message" => "Filters fetched successfully", "data" => $filters]);
        }
    }
    
    // POST - Yeni filtre ekle
    elseif ($method == 'POST') {
        $data = json_decode(file_get_contents("php://input"));
        
        if (!isset($data->name) || !isset($data->nameEn) || !isset($data->category_id)) {
            echo json_encode(["status" => 0, "message" => "Missing required fields"]);
            exit;
        }
        
        $query = "INSERT INTO filters (name, nameEn, category_id) VALUES (:name, :nameEn, :category_id)";
        $stmt = $db->prepare($query);
        
        $stmt->bindParam(':name', $data->name);
        $stmt->bindParam(':nameEn', $data->nameEn);
        $stmt->bindParam(':category_id', $data->category_id);
        
        if ($stmt->execute()) {
            echo json_encode(["status" => 1, "message" => "Filter created successfully"]);
        } else {
            echo json_encode(["status" => 0, "message" => "Filter creation failed"]);
        }
    }
    
    // PUT - Filtre güncelle
    elseif ($method == 'PUT') {
        $data = json_decode(file_get_contents("php://input"));
        
        $query = "UPDATE filters SET name = :name, nameEn = :nameEn, category_id = :category_id WHERE id = :id";
        $stmt = $db->prepare($query);
        
        $stmt->bindParam(':id', $data->id);
        $stmt->bindParam(':name', $data->name);
        $stmt->bindParam(':nameEn', $data->nameEn);
        $stmt->bindParam(':category_id', $data->category_id);
        
        if ($stmt->execute()) {
            echo json_encode(["status" => 1, "message" => "Filter updated successfully"]);
        } else {
            echo json_encode(["status" => 0, "message" => "Filter update failed"]);
        }
    }
    
    // DELETE - Filtre sil
    elseif ($method == 'DELETE') {
        $id = $_GET['id'];
        
        $query = "DELETE FROM filters WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $id);
        
        if ($stmt->execute()) {
            echo json_encode(["status" => 1, "message" => "Filter deleted successfully"]);
        } else {
            echo json_encode(["status" => 0, "message" => "Filter deletion failed"]);
        }
    }

} catch (Exception $e) {
    echo json_encode(["status" => 0, "message" => "Database error: " . $e->getMessage()]);
}
?>