<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once  'DbConnect.php';

try {
    $database = new DbConnect();
    $db = $database->connect();

    $query = "
        SELECT 
            fo.id,
            fo.value,
            fo.valueEn,
            fo.filter_id,
            f.name as filter_name
        FROM filter_options fo
        LEFT JOIN filters f ON fo.filter_id = f.id
        ORDER BY f.name, fo.value
    ";
    
    $stmt = $db->prepare($query);
    $stmt->execute();
    
    $items = array();
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $items[] = $row;
    }
    
    echo json_encode(["status" => 1, "message" => "Filter options with filters fetched successfully", "data" => $items]);

} catch (Exception $e) {
    echo json_encode(["status" => 0, "message" => "Database error: " . $e->getMessage()]);
}
?>