<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once  'DbConnect.php';

$method = $_SERVER['REQUEST_METHOD'];

try {
    $database = new DbConnect();
    $db = $database->connect();

    // GET - Tüm filtre seçeneklerini veya belirli bir filtreye ait seçenekleri getir
    if ($method == 'GET') {
        if (isset($_GET['id'])) {
            $id = $_GET['id'];
            $query = "SELECT * FROM filter_options WHERE id = :id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':id', $id);
            $stmt->execute();
            
            if ($stmt->rowCount() > 0) {
                $option = $stmt->fetch(PDO::FETCH_ASSOC);
                echo json_encode(["status" => 1, "message" => "Filter option fetched successfully", "data" => [$option]]);
            } else {
                echo json_encode(["status" => 0, "message" => "Filter option not found", "data" => []]);
            }
        } 
        elseif (isset($_GET['filter_id'])) {
            $filter_id = $_GET['filter_id'];
            $query = "SELECT * FROM filter_options WHERE filter_id = :filter_id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':filter_id', $filter_id);
            $stmt->execute();
            
            $options = array();
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $options[] = $row;
            }
            
            echo json_encode(["status" => 1, "message" => "Filter options fetched successfully", "data" => $options]);
        }
        else {
            $query = "SELECT * FROM filter_options";
            $stmt = $db->prepare($query);
            $stmt->execute();
            
            $options = array();
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $options[] = $row;
            }
            
            echo json_encode(["status" => 1, "message" => "Filter options fetched successfully", "data" => $options]);
        }
    }
    
    // POST - Yeni filtre seçeneği ekle
    elseif ($method == 'POST') {
        $data = json_decode(file_get_contents("php://input"));
        
        $query = "INSERT INTO filter_options (value, valueEn, filter_id) VALUES (:value, :valueEn, :filter_id)";
        $stmt = $db->prepare($query);
        
        $stmt->bindParam(':value', $data->value);
        $stmt->bindParam(':valueEn', $data->valueEn);
        $stmt->bindParam(':filter_id', $data->filter_id);
        
        if ($stmt->execute()) {
            echo json_encode(["status" => 1, "message" => "Filter option created successfully"]);
        } else {
            echo json_encode(["status" => 0, "message" => "Filter option creation failed"]);
        }
    }
    
    // PUT - Filtre seçeneği güncelle
    elseif ($method == 'PUT') {
        $data = json_decode(file_get_contents("php://input"));
        
        $query = "UPDATE filter_options SET value = :value, valueEn = :valueEn  WHERE id = :id";
        $stmt = $db->prepare($query);
        
        $stmt->bindParam(':id', $data->id);
        $stmt->bindParam(':value', $data->value);
        $stmt->bindParam(':valueEn', $data->valueEn);
        
        if ($stmt->execute()) {
            echo json_encode(["status" => 1, "message" => "Filter option updated successfully"]);
        } else {
            echo json_encode(["status" => 0, "message" => "Filter option update failed"]);
        }
    }
    
    // DELETE - Filtre seçeneği sil
    elseif ($method == 'DELETE') {
        $id = $_GET['id'];
        
        $query = "DELETE FROM filter_options WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $id);
        
        if ($stmt->execute()) {
            echo json_encode(["status" => 1, "message" => "Filter option deleted successfully"]);
        } else {
            echo json_encode(["status" => 0, "message" => "Filter option deletion failed"]);
        }
    }

} catch (Exception $e) {
    echo json_encode(["status" => 0, "message" => "Database error: " . $e->getMessage()]);
}
?>