<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

include 'DbConnect.php';
$objDb = new DbConnect();
$conn = $objDb->connect();

if ($conn == null) {
    $response['message'] = 'Veritabanı bağlantısı başarısız.';
    echo json_encode($response);
    exit();
}

$method = $_SERVER['REQUEST_METHOD'];
$path = explode('/', trim($_SERVER['REQUEST_URI'], '/'));

$response = ['status' => 0, 'message' => '', 'data' => []];

if ($method === "GET") {
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    $sql = "SELECT SQL_NO_CACHE 
                p.id, 
                p.name, 
                p.nameEn, 
                p.description, 
                p.descriptionEn, 
                p.information, 
                p.informationEn, 
                p.isNew, 
                p.isBestseller, 
                p.discount, 
                p.discountSituation, 
                p.firstPrice, 
                p.secondPrice,
                p.image1, p.image2, p.image3, p.image4, p.image5,
                c.id AS categoryId,
                c.name AS category,
                c.nameEn AS categoryEn
            FROM products p
            LEFT JOIN categories c ON p.category_id = c.id";
    
    if (!empty($id)) {
        $sql .= " WHERE p.id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
    } else {
        $stmt = $conn->prepare($sql);
    }

    $stmt->execute();
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response['status'] = 1;
    $response['message'] = 'Products fetched successfully';
    $response['data'] = $products;
    echo json_encode($response);
    exit();
}

if ($method === "POST") {
    $data = json_decode(file_get_contents('php://input'), true);
    if (empty($data)) {
        $data = $_POST;
    }

    $id = isset($data['id']) ? $data['id'] : null;
    $name = $data['name'];
    $nameEn = $data['nameEn'];
    $description = $data['description'];
    $descriptionEn = $data['descriptionEn'];
    $information = $data['information'];
    $informationEn = $data['informationEn'];
    $categoryId = $data['category_id']; // ✅ Artıq category yox, category_id
    $isNew = $data['isNew'];
    $isBestseller = $data['isBestseller'];
    $discount = $data['discount'];
    $discountSituation = $data['discountSituation'];
    $firstPrice = $data['firstPrice'];
    $secondPrice = $data['secondPrice'];

    $imageFields = ['image1', 'image2', 'image3', 'image4', 'image5'];
    $imagePaths = [];

    foreach ($imageFields as $fieldName) {
        $imagePaths[$fieldName] = null;

        if (isset($_FILES[$fieldName]) && $_FILES[$fieldName]['error'] === 0) {
            $target_dir = "products/images/";
            $image = basename($_FILES[$fieldName]['name']);
            $target_file = $target_dir . uniqid() . "_" . $image;
            $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

            $allowedTypes = ['jpg', 'jpeg', 'png', 'gif'];
            if (!in_array($imageFileType, $allowedTypes)) {
                echo json_encode(['status' => 0, 'message' => "$fieldName: Sadece JPG, JPEG, PNG ve GIF dosyaları yüklenebilir."]);
                exit();
            }

            if (!move_uploaded_file($_FILES[$fieldName]['tmp_name'], $target_file)) {
                echo json_encode(['status' => 0, 'message' => "$fieldName: Dosya yüklenirken hata oluştu."]);
                exit();
            }

            $imagePaths[$fieldName] = $target_file;
        } elseif (isset($data[$fieldName])) {
            $imagePaths[$fieldName] = $data[$fieldName];
        }
    }

    try {
        $conn->beginTransaction();

        if ($id) {
            // Güncelleme işlemi
            $setParts = [
                "name = :name",
                "nameEn = :nameEn",
                "description = :description",
                "descriptionEn = :descriptionEn",
                "information = :information",
                "informationEn = :informationEn",
                "category_id = :category_id", // ✅
                "isNew = :isNew",
                "isBestseller = :isBestseller",
                "discount = :discount",
                "discountSituation = :discountSituation",
                "firstPrice = :firstPrice",
                "secondPrice = :secondPrice"
            ];

            foreach ($imagePaths as $key => $path) {
                if ($path) {
                    $setParts[] = "$key = :$key";
                }
            }

            $sql = "UPDATE products SET " . implode(", ", $setParts) . " WHERE id = :id";
            $stmt = $conn->prepare($sql);

            $stmt->bindParam(':id', $id);
            $stmt->bindParam(':name', $name);
            $stmt->bindParam(':nameEn', $nameEn);
            $stmt->bindParam(':description', $description);
            $stmt->bindParam(':descriptionEn', $descriptionEn);
            $stmt->bindParam(':information', $information);
            $stmt->bindParam(':informationEn', $informationEn);
            $stmt->bindParam(':category_id', $categoryId);
            $stmt->bindParam(':isNew', $isNew);
            $stmt->bindParam(':isBestseller', $isBestseller);
            $stmt->bindParam(':discount', $discount);
            $stmt->bindParam(':discountSituation', $discountSituation);
            $stmt->bindParam(':firstPrice', $firstPrice);
            $stmt->bindParam(':secondPrice', $secondPrice);

            foreach ($imagePaths as $key => $path) {
                if ($path) {
                    $stmt->bindParam(":$key", $imagePaths[$key]);
                }
            }

            $stmt->execute();

            $conn->commit();
            echo json_encode(['status' => 1, 'message' => 'Product updated successfully']);
        } else {
            // Yeni kayıt ekleme
            $columns = "name, nameEn, description, descriptionEn, information, informationEn, category_id, isNew, isBestseller, discount, discountSituation, firstPrice, secondPrice";
            $placeholders = ":name, :nameEn, :description, :descriptionEn, :information, :informationEn, :category_id, :isNew, :isBestseller, :discount, :discountSituation, :firstPrice, :secondPrice";

            foreach ($imagePaths as $key => $path) {
                $columns .= ", $key";
                $placeholders .= ", :$key";
            }

            $sql = "INSERT INTO products ($columns) VALUES ($placeholders)";
            $stmt = $conn->prepare($sql);

            $stmt->bindParam(':name', $name);
            $stmt->bindParam(':nameEn', $nameEn);
            $stmt->bindParam(':description', $description);
            $stmt->bindParam(':descriptionEn', $descriptionEn);
            $stmt->bindParam(':information', $information);
            $stmt->bindParam(':informationEn', $informationEn);
            $stmt->bindParam(':category_id', $categoryId);
            $stmt->bindParam(':isNew', $isNew);
            $stmt->bindParam(':isBestseller', $isBestseller);
            $stmt->bindParam(':discount', $discount);
            $stmt->bindParam(':discountSituation', $discountSituation);
            $stmt->bindParam(':firstPrice', $firstPrice);
            $stmt->bindParam(':secondPrice', $secondPrice);

            foreach ($imagePaths as $key => $path) {
                $stmt->bindValue(":$key", $path);
            }

            $stmt->execute();
            $productId = $conn->lastInsertId();

            $conn->commit();
            echo json_encode(['status' => 1, 'message' => 'Product added successfully', 'product_id' => $productId]);
        }
    } catch (PDOException $e) {
        $conn->rollBack();
        echo json_encode(['status' => 0, 'message' => 'Error: ' . $e->getMessage()]);
    }
    exit();
}

if ($method === "DELETE") {
    $id = isset($_GET['id']) ? $_GET['id'] : null;
    
    if ($id) {
        try {
            $conn->beginTransaction();

            // Sonra ürünü sil
            $stmt = $conn->prepare("DELETE FROM products WHERE id = :id");
            $stmt->bindParam(':id', $id);
            $stmt->execute();

            $conn->commit();
            $response['status'] = 1;
            $response['message'] = 'Product and related data deleted successfully';
        } catch (PDOException $e) {
            $conn->rollBack();
            $response['status'] = 0;
            $response['message'] = 'Error deleting product: ' . $e->getMessage();
        }
    } else {
        $response['status'] = 0;
        $response['message'] = 'Invalid product ID';
    }

    echo json_encode($response);
    exit();
}

$response['message'] = 'Method not allowed';
echo json_encode($response);
?>
