<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include 'DbConnect.php'; // Veritabanı bağlantı dosyası
$objDb = new DbConnect();
$conn = $objDb->connect();

// Veritabanı bağlantısını kontrol et
if ($conn == null) {
    $response['message'] = 'Veritabanı bağlantısı başarısız.';
    echo json_encode($response);
    exit();
}

$method = $_SERVER['REQUEST_METHOD'];
$path = explode('/', trim($_SERVER['REQUEST_URI'], '/')); // Doğru yazım

$response = ['status' => 0, 'message' => '', 'data' => []]; // data ekledik

if ($method === "GET") {
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    if (!empty($id)) {
        // Tək kateqoriya + filterlər
        $sql = "SELECT id, name, nameEn, image FROM categories WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $category = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($category) {
            // Filterləri gətir
            $sqlFilters = "SELECT * FROM filters WHERE category_id = :catId";
            $stmtFilters = $conn->prepare($sqlFilters);
            $stmtFilters->bindParam(':catId', $id);
            $stmtFilters->execute();
            $filters = $stmtFilters->fetchAll(PDO::FETCH_ASSOC);

            // Hər filterin seçimlərini əlavə edək
            foreach ($filters as &$filter) {
                $sqlOptions = "SELECT * FROM filter_options WHERE filter_id = :fid";
                $stmtOptions = $conn->prepare($sqlOptions);
                $stmtOptions->bindParam(':fid', $filter['id']);
                $stmtOptions->execute();
                $filter['options'] = $stmtOptions->fetchAll(PDO::FETCH_ASSOC);
            }

            $category['filters'] = $filters;
        }

        $response['data'] = $category ? [$category] : [];
    } else {
        // Bütün kateqoriyalar + filterlər
        $sql = "SELECT id, name, nameEn, image FROM categories";
        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($categories as &$category) {
            $sqlFilters = "SELECT * FROM filters WHERE category_id = :catId";
            $stmtFilters = $conn->prepare($sqlFilters);
            $stmtFilters->bindParam(':catId', $category['id']);
            $stmtFilters->execute();
            $filters = $stmtFilters->fetchAll(PDO::FETCH_ASSOC);

            foreach ($filters as &$filter) {
                $sqlOptions = "SELECT * FROM filter_options WHERE filter_id = :fid";
                $stmtOptions = $conn->prepare($sqlOptions);
                $stmtOptions->bindParam(':fid', $filter['id']);
                $stmtOptions->execute();
                $filter['options'] = $stmtOptions->fetchAll(PDO::FETCH_ASSOC);
            }

            $category['filters'] = $filters;
        }

        $response['data'] = $categories;
    }

    $response['status'] = 1;
    $response['message'] = 'Categories fetched successfully';
    echo json_encode($response);
    exit();
}




if ($method === "PUT") {
    $putData = json_decode(file_get_contents("php://input"), true); // JSON verisini alıyoruz

    $id = isset($putData['id']) ? $putData['id'] : null;
    $name = isset($putData['name']) ? $putData['name'] : '';
    $nameEn = isset($putData['nameEn']) ? $putData['nameEn'] : '';

    
    if (!empty($id)) {
        // Ürünü güncelleme SQL sorgusu
        $sql = "UPDATE categories SET name = :name, nameEn = :nameEn WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->bindParam(':name', $name);
        $stmt->bindParam(':nameEn', $nameEn);

        if ($stmt->execute()) {
            $response['status'] = 1;
            $response['message'] = 'Product updated successfully';
        } else {
            $response['status'] = 0;
            $response['message'] = 'Error updating product';
        }
    } else {
        $response['status'] = 0;
        $response['message'] = 'Product ID is required for update';
    }

    echo json_encode($response);
    exit();
}



if ($method === "DELETE") {
    // Retrieve the ID directly from the URL query parameter
    $id = isset($_GET['id']) ? $_GET['id'] : null;
    error_log("Received ID from URL: " . $id);  // Log the ID received from the URLt
    
    if ($id) {
        error_log("Valid ID received: " . $id);  // Log valid ID
        
        // Perform the delete operation
        $sql = "DELETE FROM categories WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        
        $response['status'] = 1;
        $response['message'] = 'Product deleted successfully';
    } else {
        error_log("No valid ID found in request.");  // Log missing ID
        $response['status'] = 0;
        $response['message'] = 'Invalid product ID';
    }

    echo json_encode($response);
    exit();
}







// Desteklenmeyen HTTP metodları için hata mesajı
$response['message'] = 'Method not allowed';
echo json_encode($response);
?>