<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

include 'DbConnect.php'; // Veritabanı bağlantı dosyası
$objDb = new DbConnect();
$conn = $objDb->connect();

// Veritabanı bağlantısını kontrol et
if ($conn == null) {
    $response['message'] = 'Veritabanı bağlantısı başarısız.';
    echo json_encode($response);
    exit();
}

$method = $_SERVER['REQUEST_METHOD'];
$path = explode('/', trim($_SERVER['REQUEST_URI'], '/')); // Doğru yazım

$response = ['status' => 0, 'message' => '', 'data' => []]; // data ekledik

if ($method === "GET") {
    $id = isset($_GET['id']) ? $_GET['id'] : null;

    if (!empty($id)) {
        // id ile filtreleme
        $sql = "SELECT SQL_NO_CACHE id, title, titleEn, titleRu, date, dateEn, dateRu, content, contentEn, contentRu, type, meta_tag_title, meta_tag_titleEn, meta_tag_titleRu, meta_tag_description, meta_tag_descriptionEn, meta_tag_descriptionRu, meta_tag_keywords, meta_tag_keywordsEn, meta_tag_keywordsRu, image FROM blogs WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $avia = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $response['data'] = $avia;
    } else {
        // Tüm veriler
        $sql = "SELECT SQL_NO_CACHE id, title, titleEn, titleRu, date, dateEn, dateRu, content, contentEn, contentRu, type, meta_tag_title, meta_tag_titleEn, meta_tag_titleRu, meta_tag_description, meta_tag_descriptionEn, meta_tag_descriptionRu, meta_tag_keywords, meta_tag_keywordsEn, meta_tag_keywordsRu, image FROM blogs";
        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $avia = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $response['data'] = $avia;
    }
    $response['status'] = 1; // Başarı durumu
    $response['message'] = 'Avia fetched successfully'; // Mesaj
    echo json_encode($response); // Yanıtı JSON olarak döndürdük
    exit();
}



if ($method === "POST") {


    $id = isset($_POST['id']) ? $_POST['id'] : null;
    $title = $_POST['title'];
    $titleEn = $_POST['titleEn'];
    $titleRu = $_POST['titleRu'];
    $date = $_POST['date'];
    $dateEn = $_POST['dateEn'];
    $dateRu = $_POST['dateRu'];
    $content = $_POST['content'];
    $contentEn = $_POST['contentEn'];
    $contentRu = $_POST['contentRu'];
    $type = $_POST['type'];
    $meta_tag_title = $_POST['meta_tag_title'];
    $meta_tag_titleEn = $_POST['meta_tag_titleEn'];
    $meta_tag_titleRu = $_POST['meta_tag_titleRu'];
    $meta_tag_description = $_POST['meta_tag_description'];
    $meta_tag_descriptionEn = $_POST['meta_tag_descriptionEn'];
    $meta_tag_descriptionRu = $_POST['meta_tag_descriptionRu'];
    $meta_tag_keywords = $_POST['meta_tag_keywords'];
    $meta_tag_keywordsEn = $_POST['meta_tag_keywordsEn'];
    $meta_tag_keywordsRu = $_POST['meta_tag_keywordsRu'];
    
     $imagePath = null;

    // Eğer resim yüklenmişse işle
    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
        $target_dir = "blogs/";
        $image = basename($_FILES['image']['name']);
        $target_file = $target_dir . $image;
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        
        $allowedTypes = ['jpg', 'jpeg', 'png', 'gif'];
        if (!in_array($imageFileType, $allowedTypes)) {
            echo json_encode(['status' => 0, 'message' => "Sadece JPG, JPEG, PNG ve GIF dosyaları yüklenebilir."]);
            exit();
        }

        if (!move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
            echo json_encode(['status' => 0, 'message' => "Dosya yüklenirken hata oluştu."]);
            exit();
        }
        $imagePath = $target_file;
    }
    

    
    if ($id) {
        // Güncelleme işlemi
        if ($imagePath) {
            // Resim de değiştirilmiş ise resim yolunu da güncelle
            $sql = "UPDATE blogs SET title = :title, titleEn = :titleEn, titleRu = :titleRu, date = :date, dateEn = :dateEn, dateRu = :dateRu, content = :content, contentEn = :contentEn, contentRu = :contentRu, type = :type, meta_tag_title = :meta_tag_title, meta_tag_titleEn = :meta_tag_titleEn, meta_tag_titleRu = :meta_tag_titleRu, meta_tag_description = :meta_tag_description, meta_tag_descriptionEn = :meta_tag_descriptionEn, meta_tag_descriptionRu = :meta_tag_descriptionRu, meta_tag_keywords = :meta_tag_keywords, meta_tag_keywordsEn = :meta_tag_keywordsEn, meta_tag_keywordsRu = :meta_tag_keywordsRu, image = :image WHERE id = :id";
        } else {
            // Resim değişmemişse resim alanını güncelleme
            $sql = "UPDATE blogs SET  title = :title, titleEn = :titleEn, titleRu = :titleRu, date = :date, dateEn = :dateEn, dateRu = :dateRu, content = :content, contentEn = :contentEn, contentRu = :contentRu, type = :type,  meta_tag_title = :meta_tag_title, meta_tag_titleEn = :meta_tag_titleEn, meta_tag_titleRu = :meta_tag_titleRu, meta_tag_description = :meta_tag_description, meta_tag_descriptionEn = :meta_tag_descriptionEn, meta_tag_descriptionRu = :meta_tag_descriptionRu, meta_tag_keywords = :meta_tag_keywords, meta_tag_keywordsEn = :meta_tag_keywordsEn, meta_tag_keywordsRu = :meta_tag_keywordsRu WHERE id = :id";
        }
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->bindParam(':title', $title);
        $stmt->bindParam(':titleEn', $titleEn);
        $stmt->bindParam(':titleRu', $titleRu);
        $stmt->bindParam(':date', $date);
        $stmt->bindParam(':dateEn', $dateEn);
        $stmt->bindParam(':dateRu', $dateRu);
        $stmt->bindParam(':content', $content);
        $stmt->bindParam(':contentEn', $contentEn);
        $stmt->bindParam(':contentRu', $contentRu);
        $stmt->bindParam(':type', $type);
        $stmt->bindParam(':meta_tag_title', $meta_tag_title);
        $stmt->bindParam(':meta_tag_titleEn', $meta_tag_titleEn);
        $stmt->bindParam(':meta_tag_titleRu', $meta_tag_titleRu);
        $stmt->bindParam(':meta_tag_description', $meta_tag_description);
        $stmt->bindParam(':meta_tag_descriptionEn', $meta_tag_descriptionEn);
        $stmt->bindParam(':meta_tag_descriptionRu', $meta_tag_descriptionRu);
        $stmt->bindParam(':meta_tag_keywords', $meta_tag_keywords);
        $stmt->bindParam(':meta_tag_keywordsEn', $meta_tag_keywordsEn);
        $stmt->bindParam(':meta_tag_keywordsRu', $meta_tag_keywordsRu);
        
        if ($imagePath) {
            $stmt->bindParam(':image', $imagePath);
        }

        if ($stmt->execute()) {
            echo json_encode(['status' => 1, 'message' => 'Product updated successfully']);
        } else {
            echo json_encode(['status' => 0, 'message' => 'Error updating product']);
        }
    } else {
        // Yeni kayıt ekleme
        $sql = "INSERT INTO blogs (title, titleEn, titleRu, date, dateEn, dateRu, content, contentEn, contentRu, type, meta_tag_title, meta_tag_titleEn, meta_tag_titleRu, meta_tag_description, meta_tag_descriptionEn, meta_tag_descriptionRu,  meta_tag_keywords,  meta_tag_keywordsEn,  meta_tag_keywordsRu, image) 
            VALUES (:title, :titleEn, :titleRu, :date, :dateEn, :dateRu, :content, :contentEn, :contentRu, :type, :meta_tag_title, :meta_tag_titleEn, :meta_tag_titleRu, :meta_tag_description, :meta_tag_descriptionEn, :meta_tag_descriptionRu, :meta_tag_keywords, :meta_tag_keywordsEn, :meta_tag_keywordsRu, :image)";
        $stmt = $conn->prepare($sql);
    $stmt->bindParam(':title', $title);
    $stmt->bindParam(':titleEn', $titleEn);
    $stmt->bindParam(':titleRu', $titleRu);
    $stmt->bindParam(':date', $date);
    $stmt->bindParam(':dateEn', $dateEn);
    $stmt->bindParam(':dateRu', $dateRu);
    $stmt->bindParam(':content', $content);
    $stmt->bindParam(':contentEn', $contentEn);
    $stmt->bindParam(':contentRu', $contentRu);
    $stmt->bindParam(':type', $type);
    $stmt->bindParam(':meta_tag_title', $meta_tag_title);
    $stmt->bindParam(':meta_tag_titleEn', $meta_tag_titleEn);
    $stmt->bindParam(':meta_tag_titleRu', $meta_tag_titleRu);
    $stmt->bindParam(':meta_tag_description', $meta_tag_description);
    $stmt->bindParam(':meta_tag_descriptionEn', $meta_tag_descriptionEn);
    $stmt->bindParam(':meta_tag_descriptionRu', $meta_tag_descriptionRu);
    $stmt->bindParam(':meta_tag_keywords', $meta_tag_keywords);
    $stmt->bindParam(':meta_tag_keywordsEn', $meta_tag_keywordsEn);
    $stmt->bindParam(':meta_tag_keywordsRu', $meta_tag_keywordsRu);
        $stmt->bindParam(':image', $imagePath);

        if ($stmt->execute()) {
            echo json_encode(['status' => 1, 'message' => 'Product added successfully']);
        } else {
            echo json_encode(['status' => 0, 'message' => 'Product could not be added']);
        }
    }
    exit();
}



if ($method === "DELETE") {
    // Retrieve the ID directly from the URL query parameter
    $id = isset($_GET['id']) ? $_GET['id'] : null;
    error_log("Received ID from URL: " . $id);  // Log the ID received from the URL
    
    if ($id) {
        error_log("Valid ID received: " . $id);  // Log valid ID
        
        // Perform the delete operation
        $sql = "DELETE FROM blogs WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        
        $response['status'] = 1;
        $response['message'] = 'Product deleted successfully';
    } else {
        error_log("No valid ID found in request.");  // Log missing ID
        $response['status'] = 0;
        $response['message'] = 'Invalid product ID';
    }

    echo json_encode($response);
    exit();
}







// Desteklenmeyen HTTP metodları için hata mesajı
$response['message'] = 'Method not allowed';
echo json_encode($response);
?>
